package app.firezone.synk.network.Fragments;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.firebase.auth.FirebaseAuth;
import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.AboutActivity;
import app.firezone.synk.network.Activities.GamesRulesActivity;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.Activities.ScoreActivity;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Activities.ProfileActivity;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.Activities.WalletActivity;
import app.firezone.synk.network.databinding.FragmentProfileBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.User;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ProfileFragment extends Fragment {

    private FragmentProfileBinding binding;
    private MyApi myApi;

    long userId;
    String website, terms, privacy, refund, youtube, discord, referCode;

    public View onCreateView(@NonNull LayoutInflater inflater,
                             ViewGroup container, Bundle savedInstanceState) {
        binding = FragmentProfileBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        loadData();


        binding.profileBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), ProfileActivity.class));
                Toast.makeText(getContext(), "Profile Activity", Toast.LENGTH_SHORT).show();
            }
        });

        binding.helpBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), HelpActivity.class));
            }
        });

        binding.walletBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), WalletActivity.class));
            }
        });


        binding.transBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), TransactionHistoryActivity.class));
            }
        });

        binding.gamesRuleBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), GamesRulesActivity.class));
            }
        });

        binding.ToplayerBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), ScoreActivity.class));
                Toast.makeText(getContext(), "Just Minute....", Toast.LENGTH_SHORT).show();
            }
        });

        binding.aboutus.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(getContext(), AboutActivity.class));
            }
        });

        binding.webBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(website));
                startActivity(browserIntent);
            }
        });


        binding.privacyBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(privacy));
                startActivity(browserIntent);

            }
        });


        binding.termsBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(terms));
                startActivity(browserIntent);

            }
        });


        binding.rateAppBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                try {

                    startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + getActivity().getPackageName())));
                } catch (ActivityNotFoundException e) {
                    startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + getActivity().getPackageName())));

                }

            }
        });


        binding.moreAppBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(website));
                startActivity(browserIntent);
            }
        });





        String appname = getString(R.string.app_name);

        binding.shareBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    Intent shareIntent = new Intent(Intent.ACTION_SEND);
                    shareIntent.setType("text/plain");
                    shareIntent.putExtra(Intent.EXTRA_SUBJECT, "Check out this gaming app!");

                    String shareMessage = "Hi, friend!\n" +
                            appname + " is my favorite gaming app – play and win real cash every day!\n" +
                            "Download now and get ₹10 instantly, plus 20% cashback on your first deposit.\n" +
                            "My referral code: " + referCode + "\n" +
                            "Download and play now: " + website;

                    shareIntent.putExtra(Intent.EXTRA_TEXT, shareMessage);
                    startActivity(Intent.createChooser(shareIntent, "Choose an app to share"));
                } catch (Exception e) {
                    Toast.makeText(getContext(), "Error", Toast.LENGTH_SHORT).show();
                }

            }
        });



        binding.logout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder alert = new AlertDialog.Builder(getContext());
                alert.setMessage("Are you sure you want to logout?");

                alert.setNegativeButton("No", (dialog, which) -> {
                    // Do nothing
                });

                alert.setPositiveButton("Yes", (dialog, which) -> {
                    // 1. Call Laravel logout API
                    MyApi api = APIClient.getApiClient(getContext()).create(MyApi.class);
                    Call<ResponseBody> call = api.logout();

                    call.enqueue(new Callback<ResponseBody>() {
                        @Override
                        public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                            performLocalLogout(); // Always logout locally
                        }

                        @Override
                        public void onFailure(Call<ResponseBody> call, Throwable t) {
                            performLocalLogout(); // Still logout locally if failed
                        }
                    });
                });

                alert.show();
            }

            private void performLocalLogout() {
                // Firebase sign out
                FirebaseAuth.getInstance().signOut();

                // Google sign out
                GoogleSignInClient googleSignInClient = GoogleSignIn.getClient(getContext(), GoogleSignInOptions.DEFAULT_SIGN_IN);
                googleSignInClient.signOut().addOnCompleteListener(task -> {
                    // Shared Pref Clear
                    SharedPrefManager.getInstance(getContext()).clear();

                    // Redirect to LoginActivity
                    Intent intent = new Intent(getContext(), LoginActivity.class);
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                    startActivity(intent);
                    Toast.makeText(getContext(), "Logged out successfully", Toast.LENGTH_SHORT).show();
                });
            }
        });




        long userId = SharedPrefManager.getInstance(requireContext()).getUserId();
        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (binding == null || !isAdded()) return;

                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    binding.userName.setText(model.getName());
                    binding.email.setText(model.getEmail());

                    double totalBal = model.getDepoBalance() + model.getWinBalance() + model.getBonusBalance();

                    referCode = model.getReferCode();

                    Picasso.get()
                            .load(model.getProfile())
                            .placeholder(R.drawable.new_users)
                            .into(binding.userProfile);
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
                // Optionally log or show error
            }
        });




        return root;
    }
    private void loadData() {
        MyApi myApi = APIClient.getApiClient(requireContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();

        call.enqueue(new Callback<ArrayList<AppModel>>() {
            @Override
            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    AppModel model = response.body().get(0); // Fetch first AppModel object

                    website = model.getWebsiteUrl();
                    terms = model.getTermsUrl();
                    privacy = model.getPrivacyUrl();
                    youtube = model.getYoutube();


                } else {
                    Toast.makeText(getContext(), "No data found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void gotoUrl(String s) {
        Uri uri= Uri.parse(s);
        startActivity(new Intent(Intent.ACTION_VIEW,uri));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }
}